---
generated_at: 2026-02-03 10:40:00
metrics:
  claims_total: 12
  claims_with_evidence: 11
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：109-Web Vitals

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：11 / 12、根拠なし：1
- 優先レビュー（高）
  1. **Metric型の詳細プロパティ**：web-vitalsライブラリ内部の型定義は直接検証不可

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/client/web-vitals.ts` - useReportWebVitalsフックの実装

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | useEffectでマウント時に監視を開始 | E-01 (15行目) | ○ |
| C-02 | onCLSで CLS計測 | E-01 (16行目) | ○ |
| C-03 | onFIDでFID計測 | E-01 (17行目) | ○ |
| C-04 | onLCPでLCP計測 | E-01 (18行目) | ○ |
| C-05 | onINPでINP計測 | E-01 (19行目) | ○ |
| C-06 | onFCPでFCP計測 | E-01 (20行目) | ○ |
| C-07 | onTTFBでTTFB計測 | E-01 (21行目) | ○ |
| C-08 | 依存配列に[reportWebVitalsFn] | E-01 (22行目) | ○ |
| C-09 | web-vitalsからMetric型をインポート | E-01 (10行目) | ○ |
| C-10 | コンパイル済みweb-vitalsを使用 | E-01 (2行目) | ○ |
| C-11 | 6つのon関数をインポート | E-01 (3-8行目) | ○ |
| C-12 | Metric型にname, value, rating, delta, id, entriesが含まれる | **根拠なし**（web-vitals内部型） | △ |

## 4) 不足情報（Unknown / Missing）
- web-vitalsライブラリのMetric型の詳細プロパティはコンパイル済みライブラリ内の定義
  - 候補：web-vitalsライブラリのGitHubリポジトリ / TypeScript型定義ファイル

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 非常に簡潔な実装（24行）

## 6) レビュアーチェックリスト（最小）
- [ ] web-vitalsライブラリのバージョンと対応するMetric型の確認
- [ ] useEffectのクリーンアップ関数がない点の影響確認
